# cPanel Deployment Guide

## FIXED: HTTP Error 403

**The 403 error has been fixed!** The issue was that the system was trying to compile C/C++ code locally on the server, which requires compilers (g++/gcc) that aren't available on cPanel hosting.

### Solution Applied:
- Replaced local compilation with **Piston API** (free cloud-based code execution)
- No compilers needed on your server
- Works immediately after deployment
- Faster and more reliable than local compilation

---

## Pre-Deployment Checklist

### 1. Update Configuration Files

#### `.env` File (CRITICAL!)
Open `.env` and update these values:

```env
# Database Configuration
DB_HOST=localhost
DB_USER=your_cpanel_db_user       # Your cPanel database username
DB_PASS=your_secure_password       # Your database password
DB_NAME=your_database_name         # Your database name

# Access Codes (CHANGE THESE!)
INSTRUCTOR_ACCESS_CODE=your_instructor_code_here
ADMIN_ACCESS_CODE=your_admin_code_here

# VAPID Subject
VAPID_SUBJECT=mailto:your-email@yourdomain.com
```

#### How to Get Database Credentials:
1. Log into cPanel
2. Go to **MySQL Databases**
3. Create a new database (e.g., `yourdomain_codelab`)
4. Create a new MySQL user with a strong password
5. Add the user to the database with **ALL PRIVILEGES**
6. Use these credentials in your `.env` file

---

## Deployment Steps

### Step 1: Upload Files to cPanel

1. **Compress the folder:**
   - Right-click on `Capstone_Project_CPANEL` folder
   - Select "Send to" → "Compressed (zipped) folder"
   - Name it: `capstone.zip`

2. **Upload to cPanel:**
   - Log into cPanel
   - Go to **File Manager**
   - Navigate to `public_html` (or your domain's root folder)
   - Click **Upload**
   - Upload `capstone.zip`

3. **Extract files:**
   - Right-click on `capstone.zip` in File Manager
   - Select **Extract**
   - Extract to current directory
   - Delete `capstone.zip` after extraction

### Step 2: Set Up Database

1. **Create database:**
   - Go to cPanel → **MySQL Databases**
   - Create database: `yourdomain_codelab`
   - Create user with strong password
   - Add user to database (ALL PRIVILEGES)

2. **Update .env file:**
   - In File Manager, navigate to your project folder
   - Edit `.env` file
   - Update DB_HOST, DB_USER, DB_PASS, DB_NAME
   - **Save changes**

3. **Initialize database:**
   - Visit: `https://yourdomain.com/index.php`
   - The database tables will be created automatically

### Step 3: Set File Permissions

Set the following folder permissions (via File Manager):

```
cache/          → 755 or 777
uploads/        → 755 or 777
.env            → 644 (read-only for security)
```

To change permissions:
- Right-click folder → **Permissions**
- Set to `755` or `777` for folders
- Click **Change Permissions**

### Step 4: Configure .htaccess (Optional)

Create `.htaccess` file in root directory:

```apache
# Enable PHP error logging (disable in production)
php_flag display_errors Off
php_flag log_errors On

# Set memory limit
php_value memory_limit 256M

# Set execution time
php_value max_execution_time 60

# Protect sensitive files
<FilesMatch "^\.env$">
    Order allow,deny
    Deny from all
</FilesMatch>
```

### Step 5: Test the Deployment

1. **Test homepage:**
   ```
   https://yourdomain.com/
   ```

2. **Test code execution:**
   - Register a student account
   - Try running a simple C++ program:
   ```cpp
   #include <iostream>
   using namespace std;

   int main() {
       cout << "Hello, World!" << endl;
       return 0;
   }
   ```

3. **Verify compilation works:**
   - Should execute successfully
   - No 403 errors
   - Output: "Hello, World!"

---

## Security Recommendations

### 1. Change Access Codes
Update in `.env`:
```env
INSTRUCTOR_ACCESS_CODE=your_strong_unique_code
ADMIN_ACCESS_CODE=your_strong_unique_code
```

### 2. Generate New VAPID Keys
Visit: https://vapidkeys.com/
Update in `.env`:
```env
VAPID_PUBLIC_KEY=your_new_public_key
VAPID_PRIVATE_KEY=your_new_private_key
```

### 3. Secure Database User
- Create dedicated database user (not root)
- Use strong password (20+ characters)
- Grant only necessary privileges

### 4. Protect .env File
Add to `.htaccess`:
```apache
<FilesMatch "^\.env$">
    Order allow,deny
    Deny from all
</FilesMatch>
```

### 5. Enable HTTPS
- In cPanel, go to **SSL/TLS Status**
- Enable SSL certificate for your domain
- Force HTTPS redirect in `.htaccess`:
```apache
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

---

## Troubleshooting

### Issue: Database Connection Failed
**Solution:**
- Verify database credentials in `.env`
- Check if database user has correct privileges
- Ensure database exists in cPanel

### Issue: Code Execution Not Working
**Solution:**
- Check if cURL is enabled in cPanel (it usually is)
- Test internet connectivity from server
- Verify Piston API is accessible: https://emkc.org/api/v2/piston/execute

### Issue: File Upload Errors
**Solution:**
- Check folder permissions (755 or 777)
- Verify `uploads/` folder exists
- Check PHP upload limits in cPanel

### Issue: Push Notifications Not Working
**Solution:**
- Generate new VAPID keys
- Update `.env` with new keys
- Clear browser cache
- Test on HTTPS (required for push notifications)

---

## Performance Optimization

### 1. Enable OPcache
In cPanel → **PHP Selector** or **MultiPHP INI Editor**:
```ini
opcache.enable=1
opcache.memory_consumption=128
opcache.max_accelerated_files=10000
```

### 2. Increase PHP Limits
In **PHP Selector**:
```ini
memory_limit = 256M
max_execution_time = 60
upload_max_filesize = 10M
post_max_size = 10M
```

### 3. Enable Gzip Compression
Add to `.htaccess`:
```apache
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/html text/plain text/xml text/css text/javascript application/javascript
</IfModule>
```

---

## Support

### Common Questions

**Q: Do I need to install compilers on cPanel?**
A: No! The system uses Piston API for cloud-based code execution. No compilers needed.

**Q: Is the Piston API free?**
A: Yes, it's completely free and open source.

**Q: What if Piston API goes down?**
A: You can switch to Judge0 API by editing `api/execute_code.php` (backup included).

**Q: Can I use this on shared hosting?**
A: Yes! This version is designed for shared hosting environments like cPanel.

---

## Files Changed from Original

1. **api/execute_code.php** - Replaced local compilation with Piston API
2. **.env** - Updated with production-ready configuration
3. **DEPLOYMENT_GUIDE.md** - This file (new)

---

## Backup Information

- **Original files:** `Capstone_Project_DEPLOYMENT/`
- **Backup copy:** `Capstone_Project_BACKUP/`
- **Production version:** `Capstone_Project_CPANEL/` (this folder)

Deploy the `Capstone_Project_CPANEL` folder to your cPanel hosting.

---

## Need Help?

If you encounter issues:
1. Check the troubleshooting section above
2. Verify all configuration settings
3. Check cPanel error logs: **Errors** → **Error Log**
4. Test API connectivity: https://emkc.org/api/v2/piston/runtimes

Good luck with your deployment!
