# C++ Learning Management System - Production Ready

## Version: cPanel Deployment (403 Error Fixed)

This is a production-ready version of the C++ Learning Management System, optimized for cPanel hosting.

### Key Features:
- Student and Instructor portals
- Code execution with real-time compilation
- Activity management and grading
- Push notifications
- Daily coding challenges
- Timed assessments
- Anti-cheat features

### Fixed Issues:
- ✅ HTTP Error 403 resolved
- ✅ Local compilation replaced with cloud API
- ✅ No compiler installation required
- ✅ Works on shared hosting (cPanel)

### Quick Start:

1. **Read the Deployment Guide:**
   - Open `DEPLOYMENT_GUIDE.md`
   - Follow all steps carefully

2. **Update Configuration:**
   - Edit `.env` file
   - Set your database credentials
   - Change access codes

3. **Upload to cPanel:**
   - Compress this folder
   - Upload to cPanel File Manager
   - Extract in public_html

4. **Initialize Database:**
   - Visit your website URL
   - Database tables will be created automatically

### System Requirements:
- PHP 7.4 or higher
- MySQL 5.7 or higher
- cURL enabled (standard on cPanel)
- HTTPS (for push notifications)

### Code Execution:
- Uses **Piston API** (free cloud service)
- No local compilers needed
- Supports C and C++ languages
- 5-second execution timeout
- Rate limited: 15 executions per minute per user

### Security Features:
- Environment-based configuration
- Rate limiting
- Session management
- SQL injection protection
- XSS prevention
- CSRF protection

### Support:
For deployment issues, refer to `DEPLOYMENT_GUIDE.md`

### License:
Educational/Academic Use

---

**Note:** This is the production version. The original development version with local compilation is available in the `Capstone_Project_BACKUP` folder.
