<?php
require_once 'config/database.php';

$conn = getDBConnection();

echo "<h2>Adding Year Level and Section Columns...</h2>";

// Check if columns already exist
$check_year = "SHOW COLUMNS FROM users LIKE 'year_level'";
$result_year = $conn->query($check_year);

$check_section = "SHOW COLUMNS FROM users LIKE 'section'";
$result_section = $conn->query($check_section);

if ($result_year->num_rows == 0) {
    echo "<p>Adding year_level column...</p>";
    $add_year = "ALTER TABLE users ADD COLUMN year_level VARCHAR(20) DEFAULT NULL AFTER user_type";
    if ($conn->query($add_year)) {
        echo "<p style='color: green;'>✓ year_level column added successfully!</p>";
    } else {
        echo "<p style='color: red;'>✗ Error: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color: orange;'>year_level column already exists</p>";
}

if ($result_section->num_rows == 0) {
    echo "<p>Adding section column...</p>";
    $add_section = "ALTER TABLE users ADD COLUMN section VARCHAR(50) DEFAULT NULL AFTER year_level";
    if ($conn->query($add_section)) {
        echo "<p style='color: green;'>✓ section column added successfully!</p>";
    } else {
        echo "<p style='color: red;'>✗ Error: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color: orange;'>section column already exists</p>";
}

echo "<hr>";
echo "<h3>Done!</h3>";
echo "<p>Year level and section columns have been added to the database.</p>";
echo "<p><a href='student/profile.php'>Go to Student Profile</a> | <a href='admin/sections.php'>Go to Admin Sections</a></p>";

$conn->close();
?>
