<?php
session_start();
require_once '../config/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] != 'admin') {
    header('Location: ../index.php');
    exit();
}

$admin_id = $_SESSION['user_id'];
$conn = getDBConnection();

// Get user data including profile picture
$user_query = "SELECT profile_picture FROM users WHERE id = ?";
$stmt = $conn->prepare($user_query);
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
$stmt->close();

// Handle delete activity
if (isset($_GET['delete'])) {
    $activity_id = intval($_GET['delete']);
    $delete_query = "DELETE FROM activities WHERE id = ?";
    $stmt = $conn->prepare($delete_query);
    $stmt->bind_param("i", $activity_id);
    $stmt->execute();
    $stmt->close();
    header('Location: activities.php?success=deleted');
    exit();
}

// Get all activities
$activities_query = "SELECT a.*, s.subject_name, s.subject_code, u.full_name as instructor_name,
                     (SELECT COUNT(*) FROM submissions sub WHERE sub.activity_id = a.id) as submission_count
                     FROM activities a
                     JOIN subjects s ON a.subject_id = s.id
                     LEFT JOIN users u ON a.created_by = u.id
                     ORDER BY a.created_at DESC";
$activities_result = $conn->query($activities_query);
$activities = [];
while ($row = $activities_result->fetch_assoc()) {
    $activities[] = $row;
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Activities - CODELAB</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <script src="../assets/js/dark-mode.js" defer></script>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <?php if (isset($user['profile_picture']) && $user['profile_picture']): ?>
                    <img src="../<?php echo htmlspecialchars($user['profile_picture']); ?>" alt="Profile" class="nav-profile-pic">
                <?php else: ?>
                    <div class="nav-avatar">👨‍💼</div>
                <?php endif; ?>
                <h2>CODELAB ADMIN</h2>
            </div>
            <button class="burger-menu" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </button>
            <div class="nav-menu" id="nav-menu">
                <a href="dashboard.php" class="nav-link">Dashboard</a>
                <a href="users.php" class="nav-link">Manage Users</a>
                <a href="subjects.php" class="nav-link">Manage Subjects</a>
                <a href="activities.php" class="nav-link active">Manage Activities</a>
                <a href="../auth/logout.php" class="nav-link logout">Logout</a>
            </div>
        </div>
    </nav>

    <div class="main-content">
        <div class="dashboard-header">
            <h1>📝 Manage Activities</h1>
        </div>

        <?php if (isset($_GET['success'])): ?>
            <div class="alert alert-success">
                <?php if ($_GET['success'] == 'deleted') echo 'Activity deleted successfully!'; ?>
            </div>
        <?php endif; ?>

        <!-- Activities List -->
        <div class="dashboard-section full-width">
            <?php if (!empty($activities)): ?>
                <div class="activities-list">
                    <?php foreach ($activities as $activity): ?>
                        <div class="activity-item">
                            <div class="activity-info">
                                <h4><?php echo htmlspecialchars($activity['title']); ?></h4>
                                <p class="subject-tag">
                                    <?php echo htmlspecialchars($activity['subject_name']); ?>
                                    (<?php echo htmlspecialchars($activity['subject_code']); ?>)
                                </p>
                                <p style="color: var(--text-secondary); font-size: 0.9em;">
                                    👨‍🏫 <?php echo htmlspecialchars($activity['instructor_name']); ?> |
                                    📝 <?php echo $activity['submission_count']; ?> Submissions |
                                    📅 Due: <?php echo date('M d, Y', strtotime($activity['due_date'])); ?>
                                </p>
                            </div>
                            <a href="?delete=<?php echo $activity['id']; ?>"
                               class="btn btn-small btn-danger"
                               onclick="return confirm('Are you sure you want to delete this activity?')">
                                Delete
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="empty-message">📝 No activities found.</p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function toggleMenu() {
            const navMenu = document.getElementById('nav-menu');
            navMenu.classList.toggle('active');
        }
    </script>
</body>
</html>
