<?php
require_once '../config/push_config.php';

/**
 * Send push notification to a user
 *
 * @param int $user_id User ID to send notification to
 * @param string $title Notification title
 * @param string $body Notification body/message
 * @param string $url URL to open when notification is clicked
 * @param int|null $activity_id Optional activity ID
 */
function sendPushNotification($user_id, $title, $body, $url = '/Capstone_Project/student/dashboard.php', $activity_id = null) {
    $node_script = PROJECT_ROOT . '/api/send_push.js';

    // Escape arguments for shell
    $user_id = escapeshellarg($user_id);
    $title = escapeshellarg($title);
    $body = escapeshellarg($body);
    $url = escapeshellarg($url);
    $activity_id = $activity_id ? escapeshellarg($activity_id) : escapeshellarg('');

    // Build command
    $command = NODE_PATH . " " . escapeshellarg($node_script) . " $user_id $title $body $url $activity_id 2>&1";

    // Execute in background (non-blocking)
    // Check if exec() is available
    if (!function_exists('exec')) {
        // exec() is disabled - skip push notifications
        error_log("Push notifications disabled: exec() function not available");
        return;
    }

    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
        // Windows
        if (function_exists('popen') && function_exists('pclose')) {
            pclose(popen("start /B " . $command, "r"));
        }
    } else {
        // Unix/Linux
        exec($command . " > /dev/null &");
    }
}
?>
