<?php
/**
 * Compiler Detection Test
 * Upload this to your server and access via browser
 */

header('Content-Type: text/plain');

echo "=================================\n";
echo "COMPILER DETECTION TEST\n";
echo "=================================\n\n";

// Test session
session_start();
echo "✓ Session started successfully\n";
echo "Session ID: " . session_id() . "\n\n";

// Test g++
echo "Testing for g++ (C++ compiler):\n";
exec('which g++ 2>&1', $gpp_output, $gpp_code);
if ($gpp_code === 0 && !empty($gpp_output)) {
    echo "✓ g++ FOUND at: " . $gpp_output[0] . "\n";
    exec('g++ --version 2>&1', $version_output);
    echo "  Version: " . $version_output[0] . "\n";
} else {
    echo "✗ g++ NOT FOUND\n";
}

echo "\n";

// Test gcc
echo "Testing for gcc (C compiler):\n";
exec('which gcc 2>&1', $gcc_output, $gcc_code);
if ($gcc_code === 0 && !empty($gcc_output)) {
    echo "✓ gcc FOUND at: " . $gcc_output[0] . "\n";
    exec('gcc --version 2>&1', $version_output);
    echo "  Version: " . $version_output[0] . "\n";
} else {
    echo "✗ gcc NOT FOUND\n";
}

echo "\n";

// Test temp directory
echo "Testing temp directory:\n";
$temp_dir = sys_get_temp_dir();
echo "Temp dir: " . $temp_dir . "\n";
if (is_writable($temp_dir)) {
    echo "✓ Temp directory is writable\n";
} else {
    echo "✗ Temp directory is NOT writable\n";
}

echo "\n";

// Test cache directory
echo "Testing cache directory:\n";
$cache_dir = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'cache';
if (is_dir($cache_dir)) {
    echo "✓ Cache directory exists\n";
    if (is_writable($cache_dir)) {
        echo "✓ Cache directory is writable\n";
    } else {
        echo "✗ Cache directory is NOT writable\n";
        echo "  Fix: Set permissions to 777 via cPanel\n";
    }
} else {
    echo "✗ Cache directory does NOT exist\n";
    echo "  Creating cache directory...\n";
    if (mkdir($cache_dir, 0777, true)) {
        echo "✓ Cache directory created\n";
    } else {
        echo "✗ Failed to create cache directory\n";
    }
}

echo "\n";

// Test exec function
echo "Testing exec() function:\n";
if (function_exists('exec')) {
    echo "✓ exec() function is enabled\n";
} else {
    echo "✗ exec() function is DISABLED\n";
    echo "  This is a CRITICAL issue - contact your hosting provider\n";
}

echo "\n";

// Server info
echo "Server Information:\n";
echo "OS: " . PHP_OS . "\n";
echo "PHP Version: " . PHP_VERSION . "\n";
echo "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "\n";

echo "\n=================================\n";
echo "CONCLUSION:\n";
echo "=================================\n";

if ($gpp_code === 0 || $gcc_code === 0) {
    echo "✓ Compiler is available - code execution should work!\n";
    echo "  If you're still getting 403 errors, check:\n";
    echo "  1. File permissions (api folder = 755)\n";
    echo "  2. ModSecurity settings\n";
    echo "  3. Session is properly started\n";
} else {
    echo "✗ NO COMPILER FOUND on this server\n";
    echo "  This is common on shared hosting.\n";
    echo "  SOLUTION: Use an online compiler API instead\n";
    echo "  Options:\n";
    echo "  - JDoodle API (https://www.jdoodle.com/compiler-api)\n";
    echo "  - Judge0 API (https://judge0.com)\n";
    echo "  - Wandbox API (https://wandbox.org)\n";
}

echo "\n";
?>
