<?php
/**
 * Simple Test - Check if API is accessible
 * This tests if the 403 error is from ModSecurity or missing compiler
 */

// Start session properly
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Fake a user session for testing
$_SESSION['user_id'] = 999;

header('Content-Type: application/json');

// Test 1: Check if we can receive POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'test' => 'GET request received',
        'message' => 'Try sending a POST request',
        'session_id' => session_id(),
        'user_id' => $_SESSION['user_id'] ?? 'not set'
    ]);
    exit();
}

// Test 2: Check if we can receive code
$code = $_POST['code'] ?? '';
if (empty($code)) {
    echo json_encode([
        'test' => 'POST request received but no code',
        'message' => 'Send "code" parameter in POST',
        'session_id' => session_id(),
        'user_id' => $_SESSION['user_id'] ?? 'not set'
    ]);
    exit();
}

// Test 3: Check if we can execute commands
exec('echo "Hello from server" 2>&1', $output, $return_code);

echo json_encode([
    'test' => 'SUCCESS',
    'message' => 'API is accessible and exec() works!',
    'session_id' => session_id(),
    'user_id' => $_SESSION['user_id'],
    'code_received' => strlen($code) . ' bytes',
    'exec_test' => [
        'output' => implode("\n", $output),
        'return_code' => $return_code
    ],
    'next_step' => 'Now test if compiler exists using test_compiler.php'
]);
?>
