<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['endpoint'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Endpoint required']);
    exit();
}

$user_id = $_SESSION['user_id'];
$endpoint = $data['endpoint'];

$conn = getDBConnection();

$query = "DELETE FROM push_subscriptions WHERE user_id = ? AND endpoint = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("is", $user_id, $endpoint);
$stmt->execute();

$stmt->close();
$conn->close();

echo json_encode(['success' => true, 'message' => 'Subscription removed successfully']);
?>
