// Burger Menu Toggle
function toggleMenu() {
    const navMenu = document.getElementById('nav-menu');
    if (navMenu) {
        navMenu.classList.toggle('active');
    }
}

// Close menu when clicking outside
document.addEventListener('click', function(event) {
    const navMenu = document.getElementById('nav-menu');
    const burgerBtn = document.querySelector('.burger-menu');

    if (navMenu && burgerBtn) {
        if (!navMenu.contains(event.target) && !burgerBtn.contains(event.target)) {
            navMenu.classList.remove('active');
        }
    }
});

// Close menu when clicking on navigation links (for mobile)
document.addEventListener('DOMContentLoaded', function() {
    const navMenu = document.getElementById('nav-menu');
    if (navMenu) {
        const navLinks = navMenu.querySelectorAll('.nav-link');
        navLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                // Only close on mobile (when burger menu is visible)
                if (window.innerWidth <= 768) {
                    navMenu.classList.remove('active');
                }
            });
        });
    }
});
