// Instructor Tutorial Steps
const instructorTutorialSteps = [
    {
        target: '.dashboard-header',
        title: 'Welcome to Instructor Dashboard',
        icon: '👨‍🏫',
        content: 'This is your command center for managing subjects, activities, and students. Let\'s explore the key features.',
        position: 'bottom'
    },
    {
        target: 'a[href="subjects.php"]',
        title: 'Manage Your Subjects',
        icon: '📚',
        content: 'Create and manage your programming subjects here. You can organize subjects by year level and section.',
        position: 'right'
    },
    {
        target: 'a[href="activities.php"]',
        title: 'Create Activities',
        icon: '📝',
        content: 'Design programming activities and assignments for your students. Add descriptions, starter code, and expected outputs.',
        position: 'right'
    },
    {
        target: 'a[href="submissions.php"]',
        title: 'Grade Submissions',
        icon: '✅',
        content: 'Review and grade student submissions here. You can see violation counts, test their code, and provide feedback.',
        position: 'right'
    },
    {
        target: 'a[href="students.php"]',
        title: 'Track Students',
        icon: '👥',
        content: 'View all students enrolled in your subjects. Monitor their progress and manage student access to activities.',
        position: 'right'
    },
    {
        target: 'a[href="profile.php"]',
        title: 'Your Profile',
        icon: '👤',
        content: 'Manage your account settings and customize your preferences here.',
        position: 'right'
    },
    {
        target: '.dark-mode-toggle',
        title: 'Customize Your Theme',
        icon: '🎨',
        content: 'Toggle dark/light mode and choose from 4 color themes. Right-click (or long press) for theme options.',
        position: 'left'
    },
    {
        target: '.notification-bell',
        title: 'Notifications',
        icon: '🔔',
        content: 'Get notified when students submit work or when there are important updates.',
        position: 'bottom'
    }
];

// Add stats section if it exists
if (document.querySelector('.stats-grid')) {
    instructorTutorialSteps.splice(1, 0, {
        target: '.stats-grid',
        title: 'Overview Statistics',
        icon: '📊',
        content: 'Quick view of your subjects, activities, enrolled students, and pending submissions to grade.',
        position: 'bottom'
    });
}
