// Student Tutorial Steps
const studentTutorialSteps = [
    {
        target: '.dashboard-header',
        title: 'Welcome to Your Dashboard',
        icon: '🏠',
        content: 'This is your main dashboard where you can see all your activities, subjects, and progress at a glance.',
        position: 'bottom'
    },
    {
        target: 'a[href="subjects.php"]',
        title: 'Browse Subjects',
        icon: '📚',
        content: 'Click here to view all your enrolled subjects. You can also enroll in new subjects available for your year level and section.',
        position: 'right'
    },
    {
        target: 'a[href="activities.php"]',
        title: 'View Activities',
        icon: '📝',
        content: 'This is where you\'ll find all your programming assignments and activities. Pay attention to due dates!',
        position: 'right'
    },
    {
        target: 'a[href="code_challenges.php"]',
        title: 'Daily Code Challenges',
        icon: '🎮',
        content: 'Complete daily coding challenges to earn code points! New challenges reset every 24 hours. Compete with your classmates on the leaderboard.',
        position: 'right'
    },
    {
        target: 'a[href="grades.php"]',
        title: 'Check Your Grades',
        icon: '📊',
        content: 'View all your graded submissions here. You can see scores, feedback from instructors, and your overall performance.',
        position: 'right'
    },
    {
        target: 'a[href="profile.php"]',
        title: 'Your Profile',
        icon: '👤',
        content: 'Manage your account settings, upload a profile picture, and customize your theme preferences here.',
        position: 'right'
    },
    {
        target: '.dark-mode-toggle',
        title: 'Customize Your Theme',
        icon: '🎨',
        content: 'Click to toggle dark/light mode. Right-click (or long press on mobile) to choose from 4 color themes: Green, Pink, Blue, and Red!',
        position: 'left'
    },
    {
        target: '.notification-bell',
        title: 'Stay Updated',
        icon: '🔔',
        content: 'Check notifications here for new activities, graded submissions, and important announcements.',
        position: 'bottom'
    }
];

// Add pending activities if they exist
if (document.querySelector('.pending-activities')) {
    studentTutorialSteps.splice(1, 0, {
        target: '.pending-activities',
        title: 'Pending Activities',
        icon: '⏰',
        content: 'These are activities you need to complete. Click on any activity to start working on it. Remember: the anti-cheat system monitors tab switching!',
        position: 'bottom'
    });
}

// Add stats section if it exists
if (document.querySelector('.stats-grid')) {
    studentTutorialSteps.push({
        target: '.stats-grid',
        title: 'Your Statistics',
        icon: '📈',
        content: 'Track your progress here. See your completion rate, average score, and total code points earned.',
        position: 'top'
    });
}
