<?php
// Load environment variables
require_once __DIR__ . '/env_loader.php';

// Access Code Configuration - loaded from .env file
// These codes control who can register as instructor or admin
// Keep them secret and only share with authorized users

define('INSTRUCTOR_ACCESS_CODE', env('INSTRUCTOR_ACCESS_CODE', 'INSTRUCTOR2025'));
define('ADMIN_ACCESS_CODE', env('ADMIN_ACCESS_CODE', 'ADMIN2025'));

// Validate that access codes are configured
if (empty(INSTRUCTOR_ACCESS_CODE) || empty(ADMIN_ACCESS_CODE)) {
    error_log('WARNING: Access codes not properly configured. Check your .env file.');
}

// You can also use multiple codes by storing them in an array:
// define('INSTRUCTOR_ACCESS_CODES', ['INSTRUCTOR2025', 'TEACH2025']);
// define('ADMIN_ACCESS_CODES', ['ADMIN2025', 'SUPERADMIN2025']);
?>
