<?php
// Load environment variables
require_once __DIR__ . '/env_loader.php';

// Web Push Configuration - loaded from .env file
define('VAPID_PUBLIC_KEY', env('VAPID_PUBLIC_KEY', ''));
define('VAPID_PRIVATE_KEY', env('VAPID_PRIVATE_KEY', ''));
define('VAPID_SUBJECT', env('VAPID_SUBJECT', 'mailto:admin@codelab.edu'));

// Validate that VAPID keys are configured
if (empty(VAPID_PUBLIC_KEY) || empty(VAPID_PRIVATE_KEY)) {
    error_log('ERROR: VAPID keys not configured. Please check your .env file.');
}

// Path to Node.js executable
define('NODE_PATH', 'node');

// Path to project root
define('PROJECT_ROOT', dirname(__DIR__));
?>
