-- Migration: Add admin user type
-- Run this file to add admin support

USE cpp_learning_system;

-- Modify user_type to include admin
ALTER TABLE users
MODIFY COLUMN user_type ENUM('student', 'instructor', 'admin') NOT NULL;

-- Create default admin account (username: admin, password: admin123)
INSERT INTO users (username, password, email, full_name, user_type, id_number)
VALUES ('admin', '$2y$10$FSPH0Sk2VOFgWLcgIBwXauXmGpOH6a0NWvmmvkcj0rA3TMax8ian6', 'admin@codelab.com', 'System Administrator', 'admin', 'ADMIN-001')
ON DUPLICATE KEY UPDATE username=username;

SELECT 'Migration completed! Admin user type added.' AS message;
SELECT 'Default Admin Account:' AS info;
SELECT 'Username: admin, Password: admin123' AS credentials;
