<?php
// Run this file once in your browser to add the profile_picture column
// URL: http://localhost/Capstone_Project/database/migrate_profile_picture.php

require_once '../config/database.php';

$conn = getDBConnection();

echo "<h2>Database Migration: Adding Profile Picture Support</h2>";
echo "<hr>";

// Check if profile_picture column already exists
$check = $conn->query("SHOW COLUMNS FROM users LIKE 'profile_picture'");
if ($check->num_rows > 0) {
    echo "<p style='color: orange;'>✓ Profile picture column already exists. No migration needed.</p>";
    $conn->close();
    exit();
}

try {
    // Add profile_picture column
    echo "<p>Adding profile_picture column to users table...</p>";
    $sql = "ALTER TABLE users ADD COLUMN profile_picture VARCHAR(255) DEFAULT NULL AFTER user_type";

    if ($conn->query($sql)) {
        echo "<p style='color: green;'>✓ Profile picture column added successfully</p>";
        echo "<hr>";
        echo "<h3 style='color: green;'>✓ Migration completed successfully!</h3>";
        echo "<p><a href='../index.php'>← Go back to login</a></p>";
    } else {
        throw new Exception("Error adding column: " . $conn->error);
    }

} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error: " . $e->getMessage() . "</p>";
}

$conn->close();
?>
