<?php
session_start();
require_once 'config/security.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - CODELAB</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="login-wrapper">
            <div class="login-header">
                <h1>🔒 Forgot Password</h1>
                <p>Reset your account password</p>
            </div>

            <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success">
                    ✓ Password has been reset successfully! You can now login with your new password.
                </div>
            <?php endif; ?>

            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-error">
                    <?php
                    if ($_GET['error'] == 'notfound') echo '✗ Username or email not found!';
                    if ($_GET['error'] == 'password') echo '✗ Passwords do not match!';
                    if ($_GET['error'] == 'failed') echo '✗ Password reset failed. Please try again.';
                    if ($_GET['error'] == 'empty') echo '✗ Please fill in all fields!';
                    ?>
                </div>
            <?php endif; ?>

            <form action="auth/reset_password.php" method="POST" class="login-form" id="reset-form">
                <?php echo csrfField(); ?>
                <div style="background: #e8f8f5; padding: 15px; border-radius: 10px; margin-bottom: 20px; border-left: 4px solid #11998e;">
                    <p style="color: #333; font-size: 0.9em; margin: 0; line-height: 1.6;">
                        <strong>📋 How to reset:</strong><br>
                        Enter your username or email, verify your full name, then create a new password.
                    </p>
                </div>

                <div class="form-group">
                    <label for="identifier">Username or Email</label>
                    <input type="text" id="identifier" name="identifier" placeholder="Enter your username or email" required autofocus>
                </div>

                <div class="form-group">
                    <label for="full_name">Full Name (for verification)</label>
                    <input type="text" id="full_name" name="full_name" placeholder="Enter your full name" required>
                    <small style="color: #666;">This must match the name on your account</small>
                </div>

                <div class="form-group">
                    <label for="new_password">New Password</label>
                    <input type="password" id="new_password" name="new_password" placeholder="Enter new password" required minlength="6">
                    <small style="color: #666;">Minimum 6 characters</small>
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm New Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" placeholder="Re-enter new password" required minlength="6">
                </div>

                <button type="submit" class="btn btn-primary">Reset Password</button>
            </form>

            <div class="signup-link">
                <a href="index.php">← Back to Login</a>
            </div>
        </div>
    </div>

    <script>
        // Password validation
        document.getElementById('reset-form').addEventListener('submit', function(e) {
            const password = document.getElementById('new_password').value;
            const confirm = document.getElementById('confirm_password').value;

            if (password !== confirm) {
                e.preventDefault();
                alert('Passwords do not match!');
            }

            if (password.length < 6) {
                e.preventDefault();
                alert('Password must be at least 6 characters long!');
            }
        });

        // Show password strength indicator
        document.getElementById('new_password').addEventListener('input', function() {
            const password = this.value;
            const strength = document.getElementById('password-strength');

            if (password.length < 6) {
                this.style.borderColor = '#dc3545';
            } else if (password.length < 8) {
                this.style.borderColor = '#ffc107';
            } else {
                this.style.borderColor = '#28a745';
            }
        });
    </script>
</body>
</html>
