<?php
// Initialize secure session
require_once 'config/security.php';
initSecureSession();
session_start();

// Set security headers
setSecurityHeaders();

if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_type'] == 'student') {
        header('Location: student/dashboard.php');
    } elseif ($_SESSION['user_type'] == 'admin') {
        header('Location: admin/dashboard.php');
    } else {
        header('Location: instructor/dashboard.php');
    }
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CODELAB - Login</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png">
    <link rel="apple-touch-icon" href="assets/images/codelab-logo.png">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="login-wrapper">
            <div class="login-header">
                <img src="assets/images/codelab-logo.png" alt="CODELAB Logo" class="logo-img" style="width: 180px; height: auto; margin-bottom: 15px;">
                <h1>Welcome to <span class="brand-highlight">CODELAB</span></h1>
                <p>Master Programming, One Line at a Time</p>
            </div>
            
            <div class="login-tabs">
                <button class="tab-btn active" data-tab="student">Student Login</button>
                <button class="tab-btn" data-tab="instructor">Instructor Login</button>
            </div>

            <!-- Student Login Form -->
            <div class="tab-content active" id="student-tab">
                <form action="auth/login.php" method="POST" class="login-form">
                    <?php echo csrfField(); ?>
                    <input type="hidden" name="user_type" value="student">
                    <div class="form-group">
                        <label for="student-username">Username</label>
                        <input type="text" id="student-username" name="username" required autocomplete="username">
                    </div>
                    <div class="form-group">
                        <label for="student-password">Password</label>
                        <div style="position: relative;">
                            <input type="password" id="student-password" name="password" required autocomplete="current-password">
                            <button type="button" onclick="togglePassword('student-password', this)" class="password-toggle">
                                👁️
                            </button>
                        </div>
                    </div>
                    <div class="form-options">
                        <label class="remember-me">
                            <input type="checkbox" name="remember_me" value="1">
                            <span>Remember me</span>
                        </label>
                        <a href="forgot_password.php" style="color: #11998e; text-decoration: none; font-size: 0.9em;">Forgot Password?</a>
                    </div>
                    <button type="submit" class="btn btn-primary">Login as Student</button>
                </form>
                <p class="signup-link">Don't have an account? <a href="signup.php">Sign up here</a></p>
            </div>

            <!-- Instructor Login Form -->
            <div class="tab-content" id="instructor-tab">
                <form action="auth/login.php" method="POST" class="login-form">
                    <?php echo csrfField(); ?>
                    <input type="hidden" name="user_type" value="instructor">
                    <div class="form-group">
                        <label for="instructor-username">Username</label>
                        <input type="text" id="instructor-username" name="username" required autocomplete="username">
                    </div>
                    <div class="form-group">
                        <label for="instructor-password">Password</label>
                        <div style="position: relative;">
                            <input type="password" id="instructor-password" name="password" required autocomplete="current-password">
                            <button type="button" onclick="togglePassword('instructor-password', this)" class="password-toggle">
                                👁️
                            </button>
                        </div>
                    </div>
                    <div class="form-options">
                        <label class="remember-me">
                            <input type="checkbox" name="remember_me" value="1">
                            <span>Remember me</span>
                        </label>
                        <a href="forgot_password.php" style="color: #11998e; text-decoration: none; font-size: 0.9em;">Forgot Password?</a>
                    </div>
                    <button type="submit" class="btn btn-primary">Login as Instructor</button>
                </form>
                <p class="signup-link">Don't have an account? <a href="signup.php">Sign up here</a></p>
            </div>

            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-error">
                    <?php
                    if ($_GET['error'] == 'invalid') echo 'Invalid username or password!';
                    if ($_GET['error'] == 'type') echo 'Invalid user type!';
                    if ($_GET['error'] == 'logout') echo 'You have been logged out.';
                    if ($_GET['error'] == 'blocked') {
                        $wait = isset($_GET['wait']) ? intval($_GET['wait']) : 15;
                        echo 'Too many failed login attempts! Please wait ' . $wait . ' minute(s) before trying again.';
                    }
                    ?>
                </div>
            <?php endif; ?>

            <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success">
                    <?php 
                    if ($_GET['success'] == 'registered') echo 'Registration successful! Please login.';
                    ?>
        
        
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="assets/js/dark-mode.js"></script>
    <script src="assets/js/interactive-pet.js"></script>
    <script>
        // Tab switching functionality
        document.querySelectorAll('.tab-btn').forEach(button => {
            button.addEventListener('click', () => {
                const tab = button.getAttribute('data-tab');

                // Remove active class from all tabs and buttons
                document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

                // Add active class to clicked button and corresponding content
                button.classList.add('active');
                document.getElementById(tab + '-tab').classList.add('active');
            });
        });

        // Password toggle functionality
        function togglePassword(inputId, button) {
            const input = document.getElementById(inputId);
            if (input.type === 'password') {
                input.type = 'text';
                button.textContent = '🙈';
            } else {
                input.type = 'password';
                button.textContent = '👁️';
            }
        }
    </script>

    <style>
        .form-options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            flex-wrap: wrap;
            gap: 10px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            user-select: none;
        }

        .remember-me input[type="checkbox"] {
            width: 18px;
            height: 18px;
            cursor: pointer;
            accent-color: #11998e;
        }

        .remember-me span {
            color: var(--text-primary);
            font-size: 0.9em;
        }

        .password-toggle {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            font-size: 1.2em;
            padding: 5px;
            opacity: 0.7;
            transition: opacity 0.3s;
        }

        .password-toggle:hover {
            opacity: 1;
        }

        .form-group input[type="password"],
        .form-group input[type="text"] {
            padding-right: 45px;
        }

        /* CODELAB brand highlight - adapts to light/dark mode */
        .brand-highlight {
            color: var(--accent-color);
            font-weight: bold;
        }

        /* In dark mode, use lighter/brighter color for visibility */
        body.dark-mode .brand-highlight {
            color: var(--accent-light);
        }
    </style>
</body>
</html>
