<?php
/**
 * Migration Script: Add Violation Tracking Columns
 * This script adds the violation_count and is_auto_submitted columns to the submissions table
 */

require_once 'config/database.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Database Migration</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 50px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 600px; margin: 0 auto; }
        .success { color: #28a745; padding: 15px; background: #d4edda; border-left: 4px solid #28a745; margin: 10px 0; }
        .error { color: #dc3545; padding: 15px; background: #f8d7da; border-left: 4px solid #dc3545; margin: 10px 0; }
        .info { color: #0c5460; padding: 15px; background: #d1ecf1; border-left: 4px solid #17a2b8; margin: 10px 0; }
        h1 { color: #333; }
        .btn { display: inline-block; padding: 10px 20px; background: #667eea; color: white; text-decoration: none; border-radius: 5px; margin-top: 20px; }
        .btn:hover { background: #5568d3; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🔧 Database Migration</h1>
        <p>Adding violation tracking columns to submissions table...</p>";

try {
    $conn = getDBConnection();

    // Check if columns already exist
    $check_query = "SHOW COLUMNS FROM submissions LIKE 'violation_count'";
    $result = $conn->query($check_query);

    if ($result->num_rows > 0) {
        echo "<div class='info'>ℹ️ <strong>Notice:</strong> Columns already exist! No migration needed.</div>";
    } else {
        // Run the migration
        $sql = "ALTER TABLE submissions
                ADD COLUMN violation_count INT DEFAULT 0 AFTER status,
                ADD COLUMN is_auto_submitted BOOLEAN DEFAULT FALSE AFTER violation_count";

        if ($conn->query($sql) === TRUE) {
            echo "<div class='success'>✅ <strong>Success!</strong> Migration completed successfully!</div>";
            echo "<div class='info'>";
            echo "<strong>What was added:</strong><br>";
            echo "• <code>violation_count</code> column - Tracks student violations<br>";
            echo "• <code>is_auto_submitted</code> column - Marks auto-submitted activities<br>";
            echo "</div>";
        } else {
            throw new Exception($conn->error);
        }
    }

    // Verify the columns exist now
    $verify_query = "SHOW COLUMNS FROM submissions";
    $verify_result = $conn->query($verify_query);

    echo "<div class='info'><strong>Current submissions table structure:</strong><br>";
    echo "<ul>";
    while ($row = $verify_result->fetch_assoc()) {
        echo "<li><code>{$row['Field']}</code> ({$row['Type']})";
        if ($row['Field'] == 'violation_count' || $row['Field'] == 'is_auto_submitted') {
            echo " <strong style='color: #28a745;'>✓ NEW</strong>";
        }
        echo "</li>";
    }
    echo "</ul></div>";

    $conn->close();

    echo "<div class='success'>🎉 <strong>Anti-Cheat System is now fully activated!</strong></div>";
    echo "<a href='student/activities.php' class='btn'>Go to Activities →</a>";
    echo "<a href='index.php' class='btn' style='background: #6c757d; margin-left: 10px;'>Back to Home</a>";

} catch (Exception $e) {
    echo "<div class='error'>❌ <strong>Error:</strong> " . $e->getMessage() . "</div>";
    echo "<div class='info'><strong>Manual Fix:</strong><br>";
    echo "Run this SQL in phpMyAdmin:<br><br>";
    echo "<code>ALTER TABLE submissions<br>";
    echo "ADD COLUMN violation_count INT DEFAULT 0 AFTER status,<br>";
    echo "ADD COLUMN is_auto_submitted BOOLEAN DEFAULT FALSE AFTER violation_count;</code>";
    echo "</div>";
}

echo "</div></body></html>";
?>
