<?php
// Initialize secure session
require_once 'config/security.php';
initSecureSession();
session_start();

// Set security headers
setSecurityHeaders();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up - CODELAB</title>
    <link rel="icon" type="image/png" href="assets/images/favicon.png">
    <link rel="apple-touch-icon" href="assets/images/codelab-logo.png">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="signup-wrapper">
            <div class="signup-header">
                <img src="assets/images/codelab-logo.png" alt="CODELAB Logo" class="logo-img" style="width: 180px; height: auto; margin-bottom: 15px;">
                <h1>🎓 Create Your Account</h1>
                <p>Join the C/C++ Learning Community</p>
            </div>
            
            <div class="login-tabs">
                <button class="tab-btn active" data-tab="student">Student Sign Up</button>
                <button class="tab-btn" data-tab="instructor">Instructor Sign Up</button>
            </div>

            <!-- Student Sign Up Form -->
            <div class="tab-content active" id="student-tab">
                <form action="auth/register.php" method="POST" class="signup-form" id="student-form">
                    <?php echo csrfField(); ?>
                    <input type="hidden" name="user_type" value="student">
                    
                    <div class="form-group">
                        <label for="student-fullname">Full Name</label>
                        <input type="text" id="student-fullname" name="full_name" required>
                    </div>

                    <div class="form-group">
                        <label for="student-email">Email</label>
                        <input type="email" id="student-email" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="student-id-number">ID Number</label>
                        <input type="text" id="student-id-number" name="id_number" required>
                    </div>

                    <div class="form-group">
                        <label for="student-year-level">Year Level</label>
                        <select id="student-year-level" name="year_level" required>
                            <option value="">Select Year Level</option>
                            <option value="1st Year">1st Year</option>
                            <option value="2nd Year">2nd Year</option>
                            <option value="3rd Year">3rd Year</option>
                            <option value="4th Year">4th Year</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="student-section">Section</label>
                        <input type="text" id="student-section" name="section" placeholder="e.g., A, B, C, IT-301" required>
                    </div>

                    <div class="form-group">
                        <label for="student-username">Username</label>
                        <input type="text" id="student-username" name="username" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="student-password">Password</label>
                        <input type="password" id="student-password" name="password" required minlength="8">
                        <small style="color: #666;">Min 8 characters, include uppercase, lowercase, and number</small>
                    </div>

                    <div class="form-group">
                        <label for="student-confirm-password">Confirm Password</label>
                        <input type="password" id="student-confirm-password" name="confirm_password" required minlength="8">
                    </div>

                    <button type="submit" class="btn btn-primary">Sign Up as Student</button>

                    <div style="background: #e8f8f5; padding: 15px; border-radius: 10px; margin-top: 20px; border-left: 4px solid #11998e;">
                        <p style="color: #333; font-size: 0.9em; margin: 0;">
                            💡 <strong>After signing up,</strong> you can enroll in subjects from your dashboard using the subject code provided by your instructor.
                        </p>
                    </div>
                </form>
            </div>

            <!-- Instructor Sign Up Form -->
            <div class="tab-content" id="instructor-tab">
                <form action="auth/register.php" method="POST" class="signup-form" id="instructor-form">
                    <?php echo csrfField(); ?>
                    <input type="hidden" name="user_type" value="instructor">
                    
                    <div class="form-group">
                        <label for="instructor-fullname">Full Name</label>
                        <input type="text" id="instructor-fullname" name="full_name" required>
                    </div>

                    <div class="form-group">
                        <label for="instructor-email">Email</label>
                        <input type="email" id="instructor-email" name="email" required>
                    </div>

                    <div class="form-group">
                        <label for="instructor-id-number">ID Number</label>
                        <input type="text" id="instructor-id-number" name="id_number" required>
                    </div>

                    <div class="form-group">
                        <label for="instructor-username">Username</label>
                        <input type="text" id="instructor-username" name="username" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="instructor-password">Password</label>
                        <input type="password" id="instructor-password" name="password" required minlength="8">
                        <small style="color: #666;">Min 8 characters, include uppercase, lowercase, and number</small>
                    </div>

                    <div class="form-group">
                        <label for="instructor-confirm-password">Confirm Password</label>
                        <input type="password" id="instructor-confirm-password" name="confirm_password" required minlength="8">
                    </div>

                    <div class="form-group">
                        <label for="instructor-code">Instructor Access Code</label>
                        <input type="text" id="instructor-code" name="instructor_code" required>
                        <small style="color: #666;">Contact admin for the instructor access code</small>
                    </div>

                    <button type="submit" class="btn btn-primary">Sign Up as Instructor</button>
                </form>
            </div>

            <?php if (isset($_GET['error'])): ?>
                <div class="alert alert-error">
                    <?php
                    if ($_GET['error'] == 'exists') echo 'Username or email already exists!';
                    if ($_GET['error'] == 'password') echo 'Passwords do not match!';
                    if ($_GET['error'] == 'failed') echo 'Registration failed. Please try again.';
                    if ($_GET['error'] == 'invalid_code') echo 'Invalid instructor access code! Contact admin for the correct code.';
                    if ($_GET['error'] == 'invalid_admin_code') echo 'Invalid admin access code! Contact system administrator.';
                    if ($_GET['error'] == 'invalid_token') echo 'Invalid or expired invitation token!';
                    if ($_GET['error'] == 'weak_password') {
                        echo 'Password does not meet requirements: ';
                        echo htmlspecialchars($_GET['msg'] ?? 'Password too weak');
                    }
                    ?>
                </div>
            <?php endif; ?>

            <p class="login-link">Already have an account? <a href="index.php">Login here</a></p>
        </div>
    </div>

    <script src="assets/js/dark-mode.js"></script>
    <script src="assets/js/interactive-pet.js"></script>
    <script>
        // Tab switching functionality
        document.querySelectorAll('.tab-btn').forEach(button => {
            button.addEventListener('click', () => {
                const tab = button.getAttribute('data-tab');

                document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
                document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));

                button.classList.add('active');
                document.getElementById(tab + '-tab').classList.add('active');
            });
        });

        // Password validation
        document.getElementById('student-form').addEventListener('submit', function(e) {
            const password = document.getElementById('student-password').value;
            const confirm = document.getElementById('student-confirm-password').value;

            if (password !== confirm) {
                e.preventDefault();
                alert('Passwords do not match!');
            }
        });

        document.getElementById('instructor-form').addEventListener('submit', function(e) {
            const password = document.getElementById('instructor-password').value;
            const confirm = document.getElementById('instructor-confirm-password').value;

            if (password !== confirm) {
                e.preventDefault();
                alert('Passwords do not match!');
            }
        });
    </script>
</body>
</html>
